$(document).ready(function () {
    var iframe = document.getElementById("TrustPayFrame");

    iframe.style.position = 'fixed';
    iframe.style.left = 0;
    iframe.style.right = 0;
    iframe.style.top = 0;
    iframe.style.bottom = 0;
    iframe.style.width = 0;
    iframe.style.height = 0;
    iframe.style.border = 'none';
    iframe.style.opacity = 0;
    iframe.style.transition = 'opacity .5s ease-in-out';
    iframe.style.zIndex = '99999';

    if (window.addEventListener) {
        window.addEventListener("message", onMessage, false);
    }
    else if (window.attachEvent) {
        window.attachEvent("onmessage", onMessage, false);
    }

    $(".show-popup").on("click",
        function (e) {
            e.preventDefault();
            openPopup();
        });

    $('#btn_submit').on('click', function (e) {
        e.preventDefault();

        $.ajax({
            url:'/trustpay_handler.php?action=get_url',
            type: 'post',
            data: $('#checkout_confirmation').serialize(),
            dataType: 'json',
            success: function (json) {
                if(json.success) {
                    showTrustPay(json.url);
                } else {
                    alert('Request error!');
                }
            }
        });

        return false;
    })
});

function showTrustPay(url) {
    jQuery('#TrustPayFrame').attr('src', url);
    openPopup();
}

function onMessage(event) {
    var data = event.data;

    if (typeof (window[data.func]) === "function") {
        window[data.func].call(null, data.message);
    }
    else if (data === "popupLoaded") {
        if (onTrustPayPopupLoaded) {
            onTrustPayPopupLoaded();
        }
    }
}

function openPopup() {
    var iframe = document.getElementById("TrustPayFrame");
    iframe.style.opacity = 1;
    iframe.style.width = '100%';
    iframe.style.height = '100%';
}

function closePopup(message) {
    var iframe = document.getElementById('TrustPayFrame');
    iframe.style.opacity = 0;

    // Delay execution so that the iframe changes dimension only after opacity is 0
    setTimeout(function() {
        iframe.style.width = 0;
        iframe.style.height = 0;
    }, 1000);
}

function redirectPopup(url) {
    window.top.location.href = url;
}