<?php

class trustpay extends base {
    
    private $card_accepted_currencies = [
        'AUD',
        'CAD',
        'CZK',
        'DKK',
        'EUR',
        'GBP',
        'HRK',
        'HUF',
        'JPY',
        'NOK',
        'PLN',
        'RON',
        'SEK',
        'USD',
    ];
    
    public function __construct() {
        global $order;
        $this->code = 'trustpay';
        $this->title = MODULE_PAYMENT_TRUSTPAY_TEXT_TITLE;
        $this->description = MODULE_PAYMENT_TRUSTPAY_TEXT_DESCRIPTION;
        $this->sort_order = defined('MODULE_PAYMENT_TRUSTPAY_SORT_ORDER') ? MODULE_PAYMENT_TRUSTPAY_SORT_ORDER : null;
        $this->enabled = (defined('MODULE_PAYMENT_TRUSTPAY_STATUS') && MODULE_PAYMENT_TRUSTPAY_STATUS == 'True');

        if (null === $this->sort_order) return false;

        if ((int)MODULE_PAYMENT_TRUSTPAY_ORDER_STATUS_ID > 0) {
            $this->order_status = MODULE_PAYMENT_TRUSTPAY_ORDER_STATUS_ID;
        }

        if (is_object($order)) $this->update_status();

        $this->loadLib();
    }

    public function update_status() {
        global $db;
        global $order;

        if ($this->enabled && (int)MODULE_PAYMENT_TRUSTPAY_ZONE > 0 && isset($order->billing['country']['id'])) {
            $check_flag = false;
            $check = $db->Execute("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_TRUSTPAY_ZONE . "' and zone_country_id = '" . (int)$order->billing['country']['id'] . "' order by zone_id");
            while (!$check->EOF) {
                if ($check->fields['zone_id'] < 1) {
                    $check_flag = true;
                    break;
                } elseif ($check->fields['zone_id'] == $order->billing['zone_id']) {
                    $check_flag = true;
                    break;
                }
                $check->MoveNext();
            }

            if ($check_flag == false) {
                $this->enabled = false;
            }
        }

        // other status checks?
        if ($this->enabled) {
            // other checks here
        }
    }

    public function javascript_validation() {
        return false;
    }

    public function selection() {
        return array('id' => $this->code,
            'module' => $this->title);
    }
    
    public function pre_confirmation_check() {
        global $order, $messageStack;
        /*
        if($this->getPaymentMethod() == Payment::ENDPOINT_WIRE && $order->info['currency'] != MODULE_PAYMENT_TRUSTPAY_CURRENCY) {
            $messageStack->add_session('checkout_payment', MODULE_PAYMENT_TRUSTPAY_ERROR_CURRENCY, 'error');
            zen_redirect(zen_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL', true, false));
        }
        else
         * 
         */
        if(!in_array($order->info['currency'], $this->card_accepted_currencies)) {
            $messageStack->add_session('checkout_payment', MODULE_PAYMENT_TRUSTPAY_ERROR_CURRENCY, 'error');
            zen_redirect(zen_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL', true, false));
        }

        return false;
    }

    public function confirmation() {
        return false;
    }

    public function process_button() {
        global $order;

        $_SESSION['trustpay_total'] = number_format($order->info['total'] * $order->info['currency_value'], 2, '.', '');
        $_SESSION['trustpay_billing_city'] = $order->billing['city'];
        $_SESSION['trustpay_billing_country'] = $order->billing['country']['iso_code_2'];
        $_SESSION['trustpay_billing_postcode'] = $order->billing['postcode'];
        $_SESSION['trustpay_billing_street'] = $order->billing['street_address'];
        $_SESSION['trustpay_card_holder'] = $order->billing['firstname'] . ' ' . $order->billing['lastname'];
        $_SESSION['trustpay_email'] = $order->customer['email_address'];

        if(MODULE_PAYMENT_TRUSTPAY_LOGOS == 'True') {
            $img_bank = '<img src="' . HTTPS_SERVER . '/includes/modules/payment/trustpay/image/online-banking.png" alt="" style="float:right"/>';
            $img_card = '<img src="' . HTTPS_SERVER . '/includes/modules/payment/trustpay/image/visa-master_card-maestro.png" alt="" style="float:right"/>';
        } else {
            $img_bank = $img_card = '';
        }

        $process_button_string  = '<script src="' . HTTPS_SERVER . '/includes/modules/payment/trustpay/trustpay.js"></script>';
        $process_button_string .= '<iframe id="TrustPayFrame" style="width:0;height:0;border:none"></iframe>';
        $process_button_string .= '<div style="padding:30px 0 10px">';
        if (in_array(MODULE_PAYMENT_TRUSTPAY_METHODS, ['Both', 'Bank']) && $order->info['currency'] == MODULE_PAYMENT_TRUSTPAY_CURRENCY) {
            $process_button_string .= '<div><label style="display:block;">' . zen_draw_radio_field('trustpay_method', 'wire', true) . ' ' . $this->getTranslation('bank_tranfer') . $img_bank . '</label></div>';
        }
        if (in_array(MODULE_PAYMENT_TRUSTPAY_METHODS, ['Both', 'Card'])) {
            $process_button_string .= '<div><label  style="display:block;">' . zen_draw_radio_field('trustpay_method', 'card', in_array(MODULE_PAYMENT_TRUSTPAY_METHODS, [ 'Card']) ? true : false) . ' ' . $this->getTranslation('credit_card') . $img_card . '</label></div>';
        }
        $process_button_string .= '</div>';
        
        // loader
        $process_button_string .= '<script type="text/javascript">
                var trustpayTs;
                
                function onTrustPayPopupLoaded() {
                    hideLoader();
                }
                
                function showLoader() {
                    jQuery(\'#TrustPayLoader\').show();
                    trustpayTs = setTimeout(hideLoader, 10000);
                }
                
                function hideLoader() {
                    jQuery(\'#TrustPayLoader\').hide();
                    clearTimeout(trustpayTs);
                }
                
                jQuery(document).ready(function() {
                    jQuery(\'.button_confirm_order\').on(\'click\', function(){
                        showLoader();
                    });
                });
                
            </script>
            
            <link rel="stylesheet" id="trustpay-loader-css"  href="' . HTTPS_SERVER . '/includes/modules/payment/trustpay/loader.css" media="all" />
            
            <div id="TrustPayLoader">
                <div class="loaderContent">
                    <img src="' . HTTPS_SERVER . '/includes/modules/payment/trustpay/image/loader.gif" style="width:160px; height:120px; max-height: none;" alt=""/>
                </div>
            </div>';
        
        
        $process_button_string .= zen_draw_hidden_field('order_id', $this->getNewOrderId());
        
        return $process_button_string;
    }

    public function before_process() {
        return false;
    }

    public function after_process() {
        return false;
    }

    public function get_error() {
        return false;
    }

    public function check() {
        global $db;
        if (!isset($this->_check)) {
            $check_query = $db->Execute("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_TRUSTPAY_STATUS'");
            $this->_check = $check_query->RecordCount();
        }
        return $this->_check;
    }

    public function remove() {
        global $db;
        $db->Execute("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    public function keys() {
        $keys = array();

        foreach ($this->getFields() as $field) {
            $keys[] = $field['key'];
        }

        return $keys;
    }

    public function install() {
        global  $messageStack;
        if (defined('MODULE_PAYMENT_TRUSTPAY_STATUS')) {
            $messageStack->add_session('Finby module already installed.', 'error');
            zen_redirect(zen_href_link(FILENAME_MODULES, 'set=payment&module=trustpay', 'SSL'));
            return 'failed';
        }

        $this->insert($this->getFields());
    }

    protected function getTranslation($text) {
        $translate = '';

        $data = array(
            'bank_tranfer' => array(
                'en' => 'Instant bank transfers',
                'sk' => 'Okamžité bankové prevody',
                'cs' => 'Okamžité bankovní převody'
            ),
            'credit_card' => array(
                'en' => 'Card Payments',
                'sk' => 'Platby kartou',
                'cs' => 'Platby kartou'
            )
        );

        if(isset($data[$text]) && isset($data[$text][MODULE_PAYMENT_TRUSTPAY_LOCALISATION])) {
            $translate = $data[$text][MODULE_PAYMENT_TRUSTPAY_LOCALISATION];
        }

        return $translate;
    }

    protected function getFields() {
        return array(
            [
                'title'         => 'Enable finby Module',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_STATUS',
                'value'         => 'True',
                'description'   => 'Do you want to accept finby payments?',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => '',
                'set_function'  => 'zen_cfg_select_option(array(\'True\', \'False\'), ',
            ],
            [
                'title'         => 'Sort order of display.',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_SORT_ORDER',
                'value'         => '0',
                'description'   => 'Sort order of display. Lowest is displayed first.',
                'group_id'      => 6,
                'sort_order'    => 2,
                'use_function'  => '',
                'set_function'  => '',
            ],
            [
                'title'         => 'Payment Zone',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_ZONE',
                'value'         => '0',
                'description'   => 'If a zone is selected, only enable this payment method for that zone.',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => 'zen_get_zone_class_title',
                'set_function'  => 'zen_cfg_pull_down_zone_classes(',
            ],
            [
                'title'         => 'Pending Order Status',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_ORDER_STATUS_ID',
                'value'         => '0',
                'description'   => 'Set the status of orders made with this payment module to this value',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => 'zen_get_order_status_name',
                'set_function'  => 'zen_cfg_pull_down_order_statuses(',
            ],
            [
                'title'         => 'Processing Payments Order Status',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_PROCESING_ORDER_STATUS_ID',
                'value'         => '0',
                'description'   => 'Set the status of orders awaiting payment complete',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => 'zen_get_order_status_name',
                'set_function'  => 'zen_cfg_pull_down_order_statuses(',
            ],
            [
                'title'         => 'Complete Payments Order Status',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_COMPLETE_ORDER_STATUS_ID',
                'value'         => '0',
                'description'   => 'Set the status of orders after payment complete',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => 'zen_get_order_status_name',
                'set_function'  => 'zen_cfg_pull_down_order_statuses(',
            ],
            [
                'title'         => 'Enable Sandbox',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_SANDBOX',
                'value'         => 'False',
                'description'   => 'Live or Test mode.',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => '',
                'set_function'  => 'zen_cfg_select_option(array(\'Live\', \'Test\'), ',
            ],
            [
                'title'         => 'Live Account ID',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_LIVE_ACCOUNT_ID',
                'value'         => '',
                'description'   => '',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => '',
                'set_function'  => '',
            ],
            [
                'title'         => 'Live Secret Key',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_LIVE_SECRET_KEY',
                'value'         => '',
                'description'   => '',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => '',
                'set_function'  => '',
            ],
            [
                'title'         => 'Test Account ID',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_TEST_ACCOUNT_ID',
                'value'         => '',
                'description'   => '',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => '',
                'set_function'  => '',
            ],
            [
                'title'         => 'Test Secret Key',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_TEST_SECRET_KEY',
                'value'         => '',
                'description'   => '',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => '',
                'set_function'  => '',
            ],
            [
                'title'         => 'Paymrnt Methods',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_METHODS',
                'value'         => '',
                'description'   => '',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => '',
                'set_function'  => 'zen_cfg_select_option(array(\'Both\', \'Bank\', \'Card\'), ',
            ],
            [
                'title'         => 'Accepted Currency',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_CURRENCY',
                'value'         => '',
                'description'   => '',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => '',
                'set_function'  => 'zen_cfg_select_option(array(\'EUR\', \'CZK\'), ',
            ],
            [
                'title'         => 'Localisation',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_LOCALISATION',
                'value'         => '',
                'description'   => '',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => '',
                'set_function'  => 'zen_cfg_select_option(array(\'en\', \'sk\', \'cs\'), ',
            ],
            [
                'title'         => 'Show Logos',
                'key'           => 'MODULE_PAYMENT_TRUSTPAY_LOGOS',
                'value'         => 'False',
                'description'   => '',
                'group_id'      => 6,
                'sort_order'    => 0,
                'use_function'  => '',
                'set_function'  => 'zen_cfg_select_option(array(\'True\', \'False\'), ',
            ],
        );
    }

    protected function insert($fields) {
        global $db;

        foreach ($fields as $field) {
            $db->Execute("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('" . zen_db_input($field['title']) . "', '" . zen_db_input($field['key']) . "', '" . zen_db_input($field['value']) . "', '" . zen_db_input($field['description']) . "', '" . (int)$field['group_id'] . "', '" . (int)$field['sort_order'] . "', '" . zen_db_input($field['use_function']) . "', '" . zen_db_input($field['set_function']) . "', now())");
        }
    }

    protected function loadLib() {
        $lib_files = array(
            'Order',
            'Payment',
            'PaymentWire',
            'PaymentCard',
            'Payment',
            'PaymentType',
            'Response',
            'ResponseCard',
            'ResponseWire',
            'ResultCodes',
            'Signature',
        );

        foreach ($lib_files as $file) {
            require_once 'trustpay/' . $file . '.php';
        }
    }

    protected function getNewOrderId() {
        global $db;

        $last_order_id = $db->Execute("select orders_id from " . TABLE_ORDERS . " order by orders_id desc limit 1");
        $new_order_id = $last_order_id->fields['orders_id'];
        $new_order_id++;

        return $new_order_id;
    }
}