{*
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2020 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{capture name=path}
    <a href="{$order_back_url}">
        {l s='Back to order' mod='trustpay'}
    </a>
    <span class="navigation-pipe">{$navigationPipe}</span>
    <span class="navigation_page">{l s='Finby' mod='trustpay'} {l s='Payment options' mod='trustpay'}</span>
{/capture}
    
    <!-- Payment summary  -->
    <style>
        tr.even td {
            background: #FFFFFF;
        }
        tr.odd td {
            background: #EFEFEF;
        }
    </style>
    <h1>
        {l s='Payment summary' mod='trustpay'}
    </h1>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th class="cart_product first_item">{l s='Product' mod='trustpay'}</th>
                <th class="cart_description item">{l s='Description' mod='trustpay'}</th>
                <!--<th class="cart_unit item text-right">{l s='Unit price' mod='trustpay'}</th>-->
                <th class="cart_quantity item text-center">{l s='Qty' mod='trustpay'}</th>
            </tr>
        </thead>

        <tbody>
            {foreach from=$products item=product}
                <tr class="cart_item {cycle values="odd,even"}">
                    <td>{$product.name}</td>
                    <td>{$product.description_short}</td>
                    <td>{$product.cart_quantity}</td>
                </tr>
            {/foreach}
            
            <tr>
                <td colspan="3">
                    <h3>{l s='Total' mod='trustpay'}: {$total} {$currency} </h3>
                </td>
            </tr>
        </tbody>
    </table>
                
    <div>
        <h3>{l s='Delivery address' mod='trustpay'}:</h3>
        
        {$address.first_name} {$address.last_name}<br />
        {$address.address1}<br />
        {$address.postcode} {$address.city}<br />
        {$country}<br /><br />
        
        {$address.phone}<br />
        {if $address.phone_mobile}
            {$address.phone_mobile}<br />
        {/if}
        <br />
    </div>
    
    <h3>{l s='Pay by' mod='trustpay'}:</h3>
    <!-- Payment summary End  -->


    <!-- loader -->
    <script type="text/javascript">
        var trustpayTs;
        var trustpayAutoClickTs;

        function onTrustPayPopupLoaded() {
            hideLoader();
        }

        function showLoader() {
            jQuery('#TrustPayLoader').show();
            trustpayTs = setTimeout(hideLoader, 10000);
        }

        function hideLoader() {
            jQuery('#TrustPayLoader').hide();
            clearTimeout(trustpayTs);
        }
        
        jQuery( document ).ready(function() {
            jQuery('.trustpay').on('click', function(){
                showLoader();
            });
            
            
            // autoclick
            trustpayAutoClickTs = setTimeout(function(){
                jQuery('.trustpay').click();
                clearTimeout(trustpayAutoClickTs);
            }, 10000);
        });

    </script>

    
    <div id="TrustPayLoader">
        <div class="loaderContent">
            <img src="{$shop_url}modules/trustpay/views/img/loader.gif" style="width:160px; height:120px; max-height: none;" alt=""/>
        </div>
    </div>

    <!-- loader end -->

{if $allowed_card_currency}
    {if $TRUSTPAY_MODE_CC == 1 || $TRUSTPAY_MODE_CC == 2 || $TRUSTPAY_MODE_CC == 3}
        {if $type == 'card'}
        <div class="row">
        	<div class="col-xs-12">
                <p class="payment_module">
                    <a class="trustpay" id="tpcp" onclick="clearTimeout(trustpayAutoClickTs);" href="{$link->getModuleLink('trustpay', 'payment', [], true)|escape:'html'}" title="{l s='finby' mod='trustpay'}">
                        {l s='finby' mod='trustpay'}
                        <!--<span>{l s='(Card payments)' mod='trustpay'}</span>-->
                        <span>{l s='(Pay now)' mod='trustpay'}</span>
                    </a>
                </p>
            </div>
            <script type="text/javascript">
            	var trustpay_iframe_cp = '{$tpcp_url}';
            </script>
            <iframe id="trustpay_iframe_cp" allow="payment" src="#"></iframe>
            <a href="#" class="trustpay_iframe_cp">{l s='Pay via finby' mod='trustpay'}</a>
        </div>
        {/if}
    {/if}
{/if}   
{if $allowed_currency}
    {if $TRUSTPAY_MODE_BANK == 3}
        {if $type == 'wire'}
        <div class="row">
        	<div class="col-xs-12">
                <p class="payment_module">
                    <a class="trustpay" id="tpibt" onclick="clearTimeout(trustpayAutoClickTs);" href="{$link->getModuleLink('trustpay', 'payment', [], true)|escape:'html'}" title="{l s='finby' mod='trustpay'}">
                        {l s='finby' mod='trustpay'}
                        <!--<span>{l s='(Instant Bank transfers)' mod='trustpay'}</span>-->
                        <span>{l s='(Pay now)' mod='trustpay'}</span>
                    </a>
                </p>
            </div>
            <script type="text/javascript">
            	var trustpay_iframe_ibt = '{$tpibt_url}';
            </script>
            <iframe id="trustpay_iframe_ibt" allow="payment" src="#"></iframe>
            <a href="#" class="trustpay_iframe_ibt">{l s='Pay via finby' mod='trustpay'}</a>
        </div>
        {/if}
    {/if}
{/if}
