<?php

class TrustpayPaymentModuleFrontController extends ModuleFrontController
{
	public function initContent()
	{
		$this->display_column_left = false;
		$this->display_column_right = false;
                
                

		parent::initContent();
	}
        
        public function setMedia()
        {
            parent::setMedia();
            
            $this->_path = __PS_BASE_URI__.'modules/trustpay/';
            $this->addCSS($this->_path.'views/css/loader.css');
        }

	public function postProcess()
	{
            $allowed_card_currency = false;
            
            $allowed = array('AUD',
                    'CAD',
                    'CZK',
                    'DKK',
                    'EUR',
                    'GBP',
                    'HRK',
                    'HUF',
                    'JPY',
                    'NOK',
                    'PLN',
                    'RON',
                    'SEK',
                    'USD',
                );
            
            $currency = new Currency($this->context->cookie->id_currency);
            
            if (!in_array($currency->iso_code, $allowed)) {
                $allowed_card_currency = false;
            }
            else {
                $allowed_card_currency = true;
            }
        
            $allowed_currency = false;
            
            $iso_code = Configuration::get('TRUSTPAY_CURRENCY');

            if($iso_code == $currency->iso_code) {
                $allowed_currency = true;
                $allowed_card_currency = true;
            }
            
            // toto vracalo v eur, namiesto USD - v default currency
            //$total = (float)(number_format($cart->getOrderTotal(true, 3), 2, '.', ''));
            
            
            $cart = new Cart((int) $this->context->cookie->id_cart);
            $customer = new Customer((int) $cart->id_customer);
            $total = $cart->getOrderTotal(true, 3);
            $total = number_format($cart->getOrderTotal(true, 3), 2, '.', '');
            $products = $cart->getProducts();
            $address = new Address($cart->id_address_delivery);
            $country = new Country((int) $address->getFields()['id_country']);
            //$country = $country->getNameById($country->getFields()['id_country']);
            /**
             * Customer
             * ['lastname']
             * ['firstname']
             * 
             */
            //var_dump(/*$cart, $customer, $address->getFields()*/$country->name/*, $total, $products*/); die;

            $this->context->smarty->assign(array(
                'tpibt_url' => $this->module->getTpibtUrl(),
                'tpcp_url' => $this->module->getTpcpUrl(),
                'TRUSTPAY_MODE_BANK' => Configuration::get('TRUSTPAY_MODE_BANK'),
                'TRUSTPAY_MODE_CC' => Configuration::get('TRUSTPAY_MODE_CC'),
                'allowed_card_currency' => $allowed_card_currency,
                'allowed_currency' => $allowed_currency,
                'shop_url' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__,
                'order_back_url' => $this->context->link->getPageLink('order', true, null, 'step=3'),
                
                'cart' => $cart,
                'customer' => $customer,
                'total' => $total,
                'products' => $products,
                'address' => $address->getFields(),
                'country' => isset($country->name[1])? $country->name[1] : '',
                'currency' => $currency->iso_code,
                'type'     => Tools::getValue('type')
                
            ));
            
            return $this->setTemplate('payment.tpl');
	}
}