{*
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2020 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{extends file='layouts/layout-both-columns.tpl'}

{block name='left_column'}{/block}
{block name='right_column'}{/block}

{block name='content_wrapper'}
    
    <!-- Payment summary  -->
    <style>
        tr.even td {
            background: #FFFFFF;
        }
        tr.odd td {
            background: #EFEFEF;
        }
        
        .table {
            margin-bottom:0;
        }
    </style>
    <div id="content-wrapper">
    <div class="container">
    <div class="row">
        <h1>
            {l s='Payment summary' mod='trustpay'}
        </h1>
        <section class="card js-cart">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th class="cart_product first_item">{l s='Product' mod='trustpay'}</th>
                    <th class="cart_description item">{l s='Description' mod='trustpay'}</th>
                    <!--<th class="cart_unit item text-right">{l s='Unit price' mod='trustpay'}</th>-->
                    <th class="cart_quantity item text-center">{l s='Qty' mod='trustpay'}</th>
                </tr>
            </thead>

            <tbody>
                {foreach from=$products item=product}
                    <tr class="cart_item {cycle values="odd,even"}">
                        <td>{$product.name}</td>
                        <td>{$product.description_short|strip_tags}</td>
                        <td>{$product.cart_quantity}</td>
                    </tr>
                {/foreach}

                <tr>
                    <td colspan="3">
                        <h3>{l s='Total' mod='trustpay'}: {$total} {$curr_iso} </h3>
                    </td>
                </tr>
            </tbody>
        </table>
        </section>

        <section class="card js-cart">
        <table class="table table-bordered">
            <tr class="cart_item">
                <td>
                    <h3>{l s='Delivery address' mod='trustpay'}:</h3>

                    {$address.firstname} {$address.lastname}<br />
                    {$address.address1}<br />
                    {$address.postcode} {$address.city}<br />
                    {$countrystr}<br /><br />

                    {$address.phone}
                    {if $address.phone_mobile}
                        <br />{$address.phone_mobile}
                    {/if}
                </td>
            </tr>
        </table>
        </section>
    </div>
    </div>
    </div>
                
    
    <script type="text/javascript">
        // autoclick
        trustpayAutoClickTs = setTimeout(function(){
            jQuery('.trustpay').click();
            clearTimeout(trustpayAutoClickTs);
        }, 10000);
    </script>
    <!-- Payment summary End  -->
    
    <!-- loader -->
    
    <div class="TrustPayLoader">
        <div class="loaderContent">
            <img src="{$shop_url}modules/trustpay/views/img/loader.gif" style="width:160px; height:120px; max-height: none;" alt=""/>
        </div>
    </div>

    <!-- loader end -->
    
  <div id="content-wrapper">
    <div class="container">
    {if $allowed_card_currency AND $TRUSTPAY_MODE_CC != 4}
        {if $type == 'card'}
        <div class="row">
            <div class="col-xs-12">
                <h3>{l s='Pay by' mod='trustpay'}:</h3>
                <p class="payment_module">
                    <a class="trustpay btn btn-primary" id="tpcp" onclick="clearTimeout(trustpayAutoClickTs);" href="{$link->getModuleLink('trustpay', 'payment', [], true)|escape:'html'}" title="{l s='finby' mod='trustpay'}">
                        {l s='finby' mod='trustpay'}
                        <span>{l s='(Pay now)' mod='trustpay'}</span>
                    </a>
                </p>
            </div>
            <script type="text/javascript">
                var trustpay_iframe_cp = '{$tpcp_url nofilter}';
            </script>
            
             <script>
                
                function getRedirectCC() {
                    {if $view_type == 'redirect'}
                            
                        if(trustpay_iframe_cp.indexOf('&IsRedirect=true') > -1) {
                            trustpay_iframe_cp = trustpay_iframe_cp.substr(0, trustpay_iframe_cp.indexOf('&IsRedirect=true')) + trustpay_iframe_cp.substr(trustpay_iframe_cp.indexOf('&IsRedirect=true') + 16);
                        }
                        if(trustpay_iframe_cp.indexOf('&IsRedirect=false') > -1) {
                            trustpay_iframe_cp = trustpay_iframe_cp.substr(0, trustpay_iframe_cp.indexOf('&IsRedirect=false')) + trustpay_iframe_cp.substr(trustpay_iframe_cp.indexOf('&IsRedirect=false') + 17);
                        }
                    
                        trustpay_iframe_cp += '&IsRedirect=true';
                        
                        $("#tpcp").click(function(event){
                            event.preventDefault();
                            window.location.href=trustpay_iframe_cp;
                        });
                    {/if}
                }
                
                if(window.addEventListener){
                    window.addEventListener('load', getRedirectCC);
                }else{
                    window.attachEvent('onload', getRedirectCC);
                }
                
            </script>
            
            <iframe id="trustpay_iframe_cp" allow="payment" src="#"></iframe>
            <a href="#" class="trustpay_iframe_cp">{l s='Pay via finby' mod='trustpay'}</a>
        </div>
        {/if}   
    {/if}   
    {if $allowed_currency AND $TRUSTPAY_MODE_BANK != 4}
        {if $type == 'wire'}
        <div class="row">
            <div class="col-xs-12">
                <h3>{l s='Pay by' mod='trustpay'}:</h3>
                <p class="payment_module">
                    <a class="trustpay btn btn-primary" id="tpibt" onclick="clearTimeout(trustpayAutoClickTs);" href="{$link->getModuleLink('trustpay', 'payment', [], true)|escape:'html'}" title="{l s='finby' mod='trustpay'}">
                        {l s='finby' mod='trustpay'}
                        <span>{l s='(Pay now)' mod='trustpay'}</span>
                    </a>
                </p>
            </div>
            <script type="text/javascript">
                var trustpay_iframe_ibt = '{$tpibt_url nofilter}';
            </script>
            
            <script>

                function getRedirectBw() {
                    {if $view_type == 'redirect'}
                        
                        if(trustpay_iframe_ibt.indexOf('&IsRedirect=true') > -1) {
                            trustpay_iframe_ibt = trustpay_iframe_ibt.substr(0, trustpay_iframe_ibt.indexOf('&IsRedirect=true')) + trustpay_iframe_ibt.substr(trustpay_iframe_ibt.indexOf('&IsRedirect=true') + 16);
                        }
                        if(trustpay_iframe_ibt.indexOf('&IsRedirect=false') > -1) {
                            trustpay_iframe_ibt = trustpay_iframe_ibt.substr(0, trustpay_iframe_ibt.indexOf('&IsRedirect=false')) + trustpay_iframe_ibt.substr(trustpay_iframe_ibt.indexOf('&IsRedirect=false') + 17);
                        }
                        
                        trustpay_iframe_ibt += '&IsRedirect=true';

                        $("#tpibt").click(function(event){
                            event.preventDefault();
                            window.location.href=trustpay_iframe_ibt;
                        });
                    {/if}
                    
                }
                
                if(window.addEventListener){
                    window.addEventListener('load', getRedirectBw);
                }else{
                    window.attachEvent('onload', getRedirectBw);
                }

            </script>
            <iframe id="trustpay_iframe_ibt" allow="payment" src="#"></iframe>
            <a href="#" class="trustpay_iframe_ibt">{l s='Pay via finby' mod='trustpay'}</a>
        </div>
        {/if}
    {/if}
</div>
  </div>
{/block}

