/*
 * Original file: https://mapi.trustpay.eu/mapi5/Scripts/TrustPay/popup.js
*/
var allowed_popup = [];

$(document).ready(function () {


    if (window.addEventListener) {
        window.addEventListener("message", onMessage, false);
    } 
    else if (window.attachEvent) {
        window.attachEvent("onmessage", onMessage, false);
    }

    $("#HOOK_PAYMENT").on("click", '.trustpay_iframe_ibt', function(e) {
            e.preventDefault();
            openIbt();
	});

    $("#HOOK_PAYMENT").on("click", '.trustpay_iframe_cp', function(e) {
            e.preventDefault();
            openCp();
	});

	$('body').on("click", '#tpcp',function (e) {
            e.preventDefault();

            $('#trustpay_iframe_cp').attr('src', trustpay_iframe_cp);

			if ($('#trustpay_iframe_cp').length == 1) {
			    var iframe_cp = document.getElementById("trustpay_iframe_cp");

			    iframe_cp.style.position = 'fixed';
			    iframe_cp.style.left = 0;
			    iframe_cp.style.right = 0;
			    iframe_cp.style.top = 0;
			    iframe_cp.style.bottom = 0;
			    iframe_cp.style.width = 0;
			    iframe_cp.style.height = 0;
			    iframe_cp.style.border = 'none';
			    iframe_cp.style.opacity = 0;
			    iframe_cp.style.transition = 'opacity .5s ease-in-out';
			    iframe_cp.style.zIndex = '99999';
			}
			openCp();
            $('.trustpay_iframe_cp').click();
	});

	$('body').parent().on("click", '#tpibt', function (e) {
            e.preventDefault();
            
            $('#trustpay_iframe_ibt').attr('src', trustpay_iframe_ibt);

			if ($('#trustpay_iframe_ibt').length == 1) {
			    var iframe_ibt = document.getElementById("trustpay_iframe_ibt");

			    iframe_ibt.style.position = 'fixed';
			    iframe_ibt.style.left = 0;
			    iframe_ibt.style.right = 0;
			    iframe_ibt.style.top = 0;
			    iframe_ibt.style.bottom = 0;
			    iframe_ibt.style.width = 0;
			    iframe_ibt.style.height = 0;
			    iframe_ibt.style.border = 'none';
			    iframe_ibt.style.opacity = 0;
			    iframe_ibt.style.transition = 'opacity .5s ease-in-out';
			    iframe_ibt.style.zIndex = '99999';
			}
			openIbt();
            $('.trustpay_iframe_ibt').click();
	});

	if (typeof prestashop_version !== 'undefined' && prestashop_version == '17') {

    	$("#payment-confirmation button[type='submit']").on("click", function (e) {
            e.preventDefault();

            var selected_payment = $('[name="payment-option"]:checked').data('module-name');

            if (selected_payment == 'trustpay_cc') {

	            $('#trustpay_iframe_cp').attr('src', trustpay_iframe_cp);

				if ($('#trustpay_iframe_cp').length == 1) {
				    var iframe_cp = document.getElementById("trustpay_iframe_cp");

				    iframe_cp.style.position = 'fixed';
				    iframe_cp.style.left = 0;
				    iframe_cp.style.right = 0;
				    iframe_cp.style.top = 0;
				    iframe_cp.style.bottom = 0;
				    iframe_cp.style.width = 0;
				    iframe_cp.style.height = 0;
				    iframe_cp.style.border = 'none';
				    iframe_cp.style.opacity = 0;
				    iframe_cp.style.transition = 'opacity .5s ease-in-out';
				    iframe_cp.style.zIndex = '99999';
				}
				openCp();
				// $('.trustpay_iframe_cp').click();
			} else if (selected_payment == 'truspay_bw') {
	            $('#trustpay_iframe_ibt').attr('src', trustpay_iframe_ibt);

				if ($('#trustpay_iframe_ibt').length == 1) {
				    var iframe_ibt = document.getElementById("trustpay_iframe_ibt");

				    iframe_ibt.style.position = 'fixed';
				    iframe_ibt.style.left = 0;
				    iframe_ibt.style.right = 0;
				    iframe_ibt.style.top = 0;
				    iframe_ibt.style.bottom = 0;
				    iframe_ibt.style.width = 0;
				    iframe_ibt.style.height = 0;
				    iframe_ibt.style.border = 'none';
				    iframe_ibt.style.opacity = 0;
				    iframe_ibt.style.transition = 'opacity .5s ease-in-out';
				    iframe_ibt.style.zIndex = '99999';
				}
				openIbt();
				//$('.trustpay_iframe_ibt').click();
            } else {
            	$(this).click();
            }
        });		
	}

});

function onMessage(event) {
    var data = event.data;

    if (typeof (window[data.func]) === "function") {
        window[data.func].call(null, data.message);
    }
    else if (data === "popupLoaded") {
        if (onTrustPayPopupLoaded) {
            onTrustPayPopupLoaded();
        }
    }
}

function openIbtOrig() {
    var iframe = document.getElementById("trustpay_iframe_ibt");
    iframe.style.opacity = 1;
    iframe.style.width = '100%';
    iframe.style.height = '100%';
    iframe.style.display = 'block';
    iframe.focus();
    iframe.contentWindow.postMessage('redirectMessage', '*');
    iframe.contentWindow.postMessage('authorizationMessage', '*');
}

function openIbt() {
    setTimeout(openIbtOrig, 5000);
}

function openCpOrig() {
    var iframe = document.getElementById("trustpay_iframe_cp");
    iframe.style.opacity = 1;
    iframe.style.width = '100%';
    iframe.style.height = '100%';
    iframe.style.display = 'block';
    iframe.focus();
    iframe.contentWindow.postMessage('redirectMessage', '*');
    iframe.contentWindow.postMessage('authorizationMessage', '*');
}

function openCp() {
    setTimeout(openCpOrig, 5000);
}

function closePopup(message) {

	if ($('#trustpay_iframe_ibt').length == 1) {
	    var iframewire = document.getElementById('trustpay_iframe_ibt');
	    iframewire.style.opacity = 0;

	    setTimeout(function() {
	        iframewire.style.width = 0;
	        iframewire.style.height = 0;
	    }, 1000);
	}

	if ($('#trustpay_iframe_cp').length == 1) {
	    var iframecard = document.getElementById('trustpay_iframe_cp');
	    iframecard.style.opacity = 0;

	    setTimeout(function() {
	        iframecard.style.width = 0;
	        iframecard.style.height = 0;
	    }, 1000);
	}
}

function redirectPopup(url) {
    window.top.location.href = url;
}



// loader
var trustpayTs;

function onTrustPayPopupLoaded() {
    hideLoader();
}

function showLoader() {
    jQuery('.TrustPayLoader').show();
    trustpayTs = setTimeout(hideLoader, 10000);
}

function hideLoader() {
    jQuery('.TrustPayLoader').hide();
    clearTimeout(trustpayTs);
}

jQuery( document ).ready(function() {
    jQuery('#payment-confirmation div :button').on('click', function(){
        showLoader();
    });
    
    jQuery('.trustpay').on('click', function(){
        showLoader();
    });
});

