<?php

class TrustpaySuccessModuleFrontController extends ModuleFrontController
{
	public function initContent()
	{
		$this->display_column_left = false;
		$this->display_column_right = false;

		parent::initContent();
	}

    public function postProcess()
    {
    	$reference = Tools::getValue('Reference');
    	$result_code = Tools::getValue('ResultCode');
    	$acquirer_response_id = Tools::getValue('AcquirerResponseId');
    	$payment_request_id = Tools::getValue('PaymentRequestId');
    	$cart = new Cart($reference);
    	$customer = new Customer($cart->id_customer);
    	$total = (float)(number_format($cart->getOrderTotal(true, 3), 2, '.', ''));

    	$msg = '';
    	$orderState = $this->module->getOrderState($result_code);
        $id_state = Configuration::get('TRUSTPAY_OS_PROCESSING');
    	$id_order = $this->module->getIdOrder($reference);
    	
    	if(!$id_order) {
	        $this->module->validateOrder(
	            (int)$cart->id,
	            (int)$id_state,
	            $total,
	            $this->module->displayName,
	            // $orderState['msg'],
                '',
	            false,
	            (int)$cart->id_currency,
	            false,
	            $cart->secure_key
	        );
    	}

        Tools::redirect(
            'index.php?controller=order-confirmation&id_cart='.
            (int)$cart->id.'&id_module='.
            (int)$this->module->id.'&id_order='.
            $id_order.'&key='.
            $cart->secure_key
        );

        if (version_compare(_PS_VERSION_, '1.7', '>=') === true) {
            return $this->setTemplate('module:trustpay/views/templates/front/success.tpl');
        } else {
            return $this->setTemplate('success.tpl');
        }
    }
}