<?php

class TrustpayCancelModuleFrontController extends ModuleFrontController
{
	public function initContent()
	{
		$this->display_column_left = false;
		$this->display_column_right = false;

		parent::initContent();
	}

    public function postProcess()
    {
    	$reference = Tools::getValue('Reference');
    	$result_code = Tools::getValue('ResultCode');
    	$acquirer_response_id = Tools::getValue('AcquirerResponseId');
    	$payment_request_id = Tools::getValue('PaymentRequestId');
    	$result_code = Tools::getValue('ResultCode');

    	$error = '';
		switch ($acquirer_response_id) {
		    case '100.100.303':
		        $error = $this->module->l('Rejected - card expired', 'error');
		        break;
		    case '100.100.600':
		        $error = $this->module->l('Rejected - invalid CVV', 'error');
		        break;
		    case '100.100.601':
		        $error = $this->module->l('Rejected - invalid CVV', 'error');
		        break;
		    case '100.100.700':
		        $error = $this->module->l('Rejected - invalid card number', 'error');
		        break;
		    case '100.380.401':
		        $error = $this->module->l('Rejected - failed 3DS authentication', 'error');
		        break;
		    case '100.380.501':
		        $error = $this->module->l('Rejected - failed 3DS authentication', 'error');
		        break;
		    case '800.100.151':
		        $error = $this->module->l('Rejected - invalid card number', 'error');
		        break;
		    case '800.100.153':
		        $error = $this->module->l('Rejected - invalid CVV', 'error');
		        break;
		    case '800.100.155':
		        $error = $this->module->l('Rejected - insufficient funds', 'error');
		        break;
		    case '800.100.157':
		        $error = $this->module->l('Rejected - invalid expiry date', 'error');
		        break;
		    case '800.100.161':
		        $error = $this->module->l('Rejected - too many invalid tries', 'error');
		        break;
		    case '800.100.162':
		        $error = $this->module->l('Rejected - card limit exceeded', 'error');
		        break;
		    case '800.100.163':
		        $error = $this->module->l('Rejected - card limit exceeded', 'error');
		        break;
		    case '800.120.101':
		        $error = $this->module->l('Rejected - card limit exceeded', 'error');
		        break;
		    case '800.120.200':
		        $error = $this->module->l('Rejected - card limit exceeded', 'error');
		        break;
		    case '800.120.201':
		        $error = $this->module->l('Rejected - card limit exceeded', 'error');
		        break;
		}

		switch ($result_code) {
		    case '0':
		        $error = $this->module->l('Finby payment transaction has been done.');
		        break;
		    case '1':
		        $error = $this->module->l('Finby payment is pending (Offline payment).');
		        break;
		    case '2':
		        $error = $this->module->l('Finby payment was successfully announced. Waiting for payment approval.');
		        break;
		    case '3':
		        $error = $this->module->l('Finby payment was successfully authorized. Waiting for payment approval.');
		        break;
		    case '4':
		        $error = $this->module->l('Finby payment was successfully received, but it must be internally processed.');
		        break;
		    case '5':
		        $error = $this->module->l('Card payment was successfully authorized, but not captured.');
		        break;
		    case '6':
		        $error = '';
		        break;
		    case '1001':
		        $error = $this->module->l('[Code #1001] Invalid request - Data sent is not properly formatted.');
		        break;
		    case '1002':
		        $error = $this->module->l('[Code #1002] Unknown account - Account with specified ID was not found.');
		        break;
		    case '1003':
		        $error = $this->module->l('[Code #1003] Merchant account disabled - Merchant account has been disabled.');
		        break;
		    case '1004':
		        $error = $this->module->l('[Code #1004] Invalid sign - Sign of message is invalid.');
		        break;
		    case '1005':
		        $error = $this->module->l('[Code #1005] User cancel - User has cancelled payment.');
		        break;
		    case '1006':
		        $error = $this->module->l('[Code #1006] Invalid authentication - The request was not properly authenticated.');
		        break;
		    case '1007':
		        $error = $this->module->l('[Code #1007] Disposable balance - Requested transaction amount is greater than disposable balance.');
		        break;
		    case '1008':
		        $error = $this->module->l('[Code #1008] Service not allowed - Service cannot be used or permission to use given service has not been granted.');
		        break;
		    case '1009':
		        $error = $this->module->l('[Code #1009] PaySafeCard timeout - Cards allocation will be cancelled.');
		        break;
		    case '1010':
		        $error = $this->module->l('[Code #1010] Transaction not found - Transaction with specified ID was not found.');
		        break;
		    case '1011':
		        $error = $this->module->l('[Code #1011] Unsupported transaction - The requested action is not supported for the transaction.');
		        break;
		    case '1014':
		        $error = $this->module->l('[Code #1014] Transaction was rejected by issuer.');
		        break;
		    case '1100':
		        $error = $this->module->l('[Code #1100] General Error - Internal error has occurred.');
		        break;
		    case '1101':
		        $error = $this->module->l('[Code #1101] Unsupported currency conversion - Currency conversion for requested currencies is not supported.');
		        break;
		}

		Tools::redirect($this->context->link->getPageLink('order', true, null, 'step=3'));
        $this->context->smarty->assign(array(
            'order_back_url' => $this->context->link->getPageLink('order', true, null, 'step=3'),
            'error' => $error
        ));

        if (version_compare(_PS_VERSION_, '1.7', '>=') === true) {
            return $this->setTemplate('module:trustpay/views/templates/front/cancel_17.tpl');
        } else {
            return $this->setTemplate('cancel.tpl');
        }
    }
}