<?php
namespace Opencart\Catalog\Model\Extension\Trustpay4\Payment;

class TrustpayCP extends \Opencart\System\Engine\Model {
    private $card_accepted_currencies = [
        'AUD',
        'CAD',
        'CZK',
        'DKK',
        'EUR',
        'GBP',
        'HRK',
        'HUF',
        'JPY',
        'NOK',
        'PLN',
        'RON',
        'SEK',
        'USD',
    ];
    
	//public function getMethod($address) {
	public function getMethods(array $address = []): array {
		$this->load->language('extension/trustpay4/payment/trustpay_cp');
                
                if(isset($address['country_id']) && isset($address['zone_id'])) {
                    $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('payment_trustpay_cp_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");
                }
		
                $total = $this->cart->getTotal();

		if (!empty($this->session->data['vouchers'])) {
			$amounts = array_column($this->session->data['vouchers'], 'amount');
		} else {
			$amounts = [];
		}

		$total = $total + array_sum($amounts);
                
                
                if ($this->config->get('payment_trustpay_cp_total') > $total) {
			$status = false;
		} elseif (!$this->config->get('payment_trustpay_cp_geo_zone_id')) {
			$status = true;
		} elseif (isset($query) && $query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		if (!in_array(mb_strtoupper($this->session->data['currency']), $this->card_accepted_currencies)) {
                    $status = false;
                }
                
		$method_data = array();

		if ($status) {
                        /*
                         * Vzor
                            $option_data['bank_transfer'] = [
                                    'code' => 'bank_transfer.bank_transfer',
                                    'name' => $this->language->get('heading_title')
                            ];

                            $method_data = [
                                    'code'       => 'bank_transfer',
                                    'name'       => $this->language->get('heading_title'),
                                    'option'     => $option_data,
                                    'sort_order' => $this->config->get('payment_bank_transfer_sort_order')
                            ];
                         */
                        /* old
			$method_data = array(
				'code'       => 'trustpay_cp',
				'title'      => $this->language->get('text_title'),
				'terms'      => '',
				'sort_order' => $this->config->get('payment_trustpay_cp_sort_order')
			);
                        */
                        
                        $option_data = [];
                        $option_data['trustpay_cp'] = [
                                    'code' => 'trustpay_cp.trustpay_cp',
                                    'name' => $this->language->get('text_title')
                            ];
                        
                        $method_data = array(
				'code'       => 'trustpay_cp',
				'name'      => $this->language->get('text_title'),
				'option'      => $option_data,
				'sort_order' => $this->config->get('payment_trustpay_cp_sort_order')
			);
		}

		return $method_data;
	}
}
