<?php
namespace Opencart\Catalog\Model\Extension\Trustpay4\Payment;

class TrustpayBT extends \Opencart\System\Engine\Model {
	//public function getMethod($address) {
	public function getMethods(array $address = []): array {
		$this->load->language('extension/trustpay4/payment/trustpay_bt');
                
                if(isset($address['country_id']) && isset($address['zone_id'])) {
                    $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('payment_trustpay_bt_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");
                }
                
                $total = $this->cart->getTotal();

		if (!empty($this->session->data['vouchers'])) {
			$amounts = array_column($this->session->data['vouchers'], 'amount');
		} else {
			$amounts = [];
		}

		$total = $total + array_sum($amounts);
                
                if ($this->config->get('payment_trustpay_bt_total') > $total) {
                        $status = false;
		} elseif (!$this->config->get('payment_trustpay_bt_geo_zone_id')) {
			$status = true;
		} elseif (isset($query) && $query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		$currencies = array(
			'CZK',
			'EUR'
		);

		if (!in_array(strtoupper($this->session->data['currency']), $currencies)) {
			$status = false;
		}

		$method_data = array();

		if ($status) {
                        /*
			$method_data = array(
				'code'       => 'trustpay_bt',
				'title'      => $this->language->get('text_title'),
				'terms'      => '',
				'sort_order' => $this->config->get('payment_trustpay_bt_sort_order')
			);*/
                        
                        $option_data = [];
                        $option_data['trustpay_bt'] = [
                                    'code' => 'trustpay_bt.trustpay_bt',
                                    'name' => $this->language->get('text_title')
                            ];
                        
                        $method_data = array(
				'code'       => 'trustpay_bt',
				'name'      => $this->language->get('text_title'),
				'option'      => $option_data,
				'sort_order' => $this->config->get('payment_trustpay_bt_sort_order')
			);
		}

		return $method_data;
	}
}
