<?php
namespace Opencart\Admin\Controller\Extension\Trustpay4\Payment;

class TrustpayCp extends \Opencart\System\Engine\Controller {
    protected $trustpay_config = array(
        'version' => '3.3.4',
        'compatibility' => array('4.0.0.0', '4.9.9.9'),
        'routes' => array(
            // tu bolo vsade bt
            'success' => 'extension/trustpay4/payment/trustpay_cp|success',
            'cancel' => 'checkout/checkout',
            'error' => 'extension/trustpay4/payment/trustpay_cp|error',
            'notification' => 'extension/trustpay4/payment/trustpay_cp|callback',
            'debug' => 'extension/trustpay4/payment/trustpay_cp|debug'
        ),
        
        'api_merchant_portal' => array(
            'live' => 'https://amapi.finby.eu/mapi5/Card/PayPopup',
            
            // testing
            //'live' => 'https://amapi.test.local/mapi5/Card/PayPopup',
        ),
    );

    private $error = array();

    public function index() {
        $this->load->language('extension/trustpay4/payment/trustpay_cp');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        //$this->request->post['payment_trustpay_cp_config'] = serialize($this->trustpay_config);
        /*
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('payment_trustpay_cp', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }
        */
        // Heading
        $data['heading_title'] = $this->language->get('heading_title');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/payment/trustpay_cp', 'user_token=' . $this->session->data['user_token'], true)
        );
        
        $data['save'] = $this->url->link('extension/trustpay4/payment/trustpay_cp|save', 'user_token=' . $this->session->data['user_token']);
        $data['back'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment');

        
        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');
        $data['text_edit'] = $this->language->get('text_edit');

        // Tabs
        $data['tab_general'] = $this->language->get('tab_general');
        $data['tab_order_statuses'] = $this->language->get('tab_order_statuses');
        $data['tab_return_urls'] = $this->language->get('tab_return_urls');
        $data['tab_about'] = $this->language->get('tab_about');

        // General
        $data['entry_aid'] = $this->language->get('entry_aid');
        $data['help_aid'] = $this->language->get('help_aid');

        if (isset($this->request->post['payment_trustpay_cp_aid'])) {
            $data['payment_trustpay_cp_aid'] = $this->request->post['payment_trustpay_cp_aid'];
        } else {
            $data['payment_trustpay_cp_aid'] = $this->config->get('payment_trustpay_cp_aid');
        }
        /*
        if (isset($this->error['aid'])) {
            $data['error_aid'] = $this->error['aid'];
        } else {
            $data['error_aid'] = '';
        }
        */
        $data['entry_key'] = $this->language->get('entry_key');
        $data['help_key'] = $this->language->get('help_key');

        if (isset($this->request->post['payment_trustpay_cp_key'])) {
            $data['payment_trustpay_cp_key'] = $this->request->post['payment_trustpay_cp_key'];
        } else {
            $data['payment_trustpay_cp_key'] = $this->config->get('payment_trustpay_cp_key');
        }
        /*
        if (isset($this->error['key'])) {
            $data['error_key'] = $this->error['key'];
        } else {
            $data['error_key'] = '';
        }
        */
        $data['help_merchant_ib'] = $this->language->get('help_merchant_ib');
        $data['entry_merchant_ib'] = $this->language->get('entry_merchant_ib');
        $data['text_merchant_portal'] = $this->language->get('text_merchant_portal');
        $data['text_internet_banking'] = $this->language->get('text_internet_banking');
        
        $data['text_yes'] = $this->language->get('text_yes');
        $data['text_no'] = $this->language->get('text_no');

        $data['entry_test'] = $this->language->get('entry_test');
        $data['help_test'] = $this->language->get('help_test');

        $data['entry_debug'] = $this->language->get('entry_debug');
        $data['help_debug'] = $this->language->get('help_debug');

        if (isset($this->request->post['payment_trustpay_cp_debug'])) {
            $data['payment_trustpay_cp_debug'] = $this->request->post['payment_trustpay_cp_debug'];
        } else {
            $data['payment_trustpay_cp_debug'] = $this->config->get('payment_trustpay_cp_debug');
        }

        $data['entry_total'] = $this->language->get('entry_total');
        $data['help_total'] = $this->language->get('help_total');

        if (isset($this->request->post['payment_trustpay_cp_total'])) {
            $data['payment_trustpay_cp_total'] = $this->request->post['payment_trustpay_cp_total'];
        } else {
            $data['payment_trustpay_cp_total'] = $this->config->get('payment_trustpay_cp_total');
        }

        $data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
        $data['text_all_zones'] = $this->language->get('text_all_zones');

        $this->load->model('localisation/geo_zone');

        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        if (isset($this->request->post['payment_trustpay_cp_geo_zone_id'])) {
            $data['payment_trustpay_cp_geo_zone_id'] = $this->request->post['payment_trustpay_cp_geo_zone_id'];
        } else {
            $data['payment_trustpay_cp_geo_zone_id'] = $this->config->get('payment_trustpay_cp_geo_zone_id');
        }

        $data['entry_status'] = $this->language->get('entry_status');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');

        if (isset($this->request->post['payment_trustpay_cp_status'])) {
            $data['payment_trustpay_cp_status'] = $this->request->post['payment_trustpay_cp_status'];
        } else {
            $data['payment_trustpay_cp_status'] = $this->config->get('payment_trustpay_cp_status');
        }

        $data['entry_sort_order'] = $this->language->get('entry_sort_order');

        if (isset($this->request->post['payment_trustpay_cp_sort_order'])) {
            $data['payment_trustpay_cp_sort_order'] = $this->request->post['payment_trustpay_cp_sort_order'];
        } else {
            $data['payment_trustpay_cp_sort_order'] = $this->config->get('payment_trustpay_cp_sort_order');
        }

        // Order Statuses
        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $data['entry_success_status'] = $this->language->get('entry_success_status');
        $data['help_success_status'] = $this->language->get('help_success_status');

        if (isset($this->request->post['payment_trustpay_cp_success_status_id'])) {
            $data['payment_trustpay_cp_success_status_id'] = $this->request->post['payment_trustpay_cp_success_status_id'];
        } else {
            $data['payment_trustpay_cp_success_status_id'] = $this->config->get('payment_trustpay_cp_success_status_id');
        }

        $data['entry_pending_status'] = $this->language->get('entry_pending_status');
        $data['help_pending_status'] = $this->language->get('help_pending_status');

        if (isset($this->request->post['payment_trustpay_cp_pending_status_id'])) {
            $data['payment_trustpay_cp_pending_status_id'] = $this->request->post['payment_trustpay_cp_pending_status_id'];
        } else {
            $data['payment_trustpay_cp_pending_status_id'] = $this->config->get('payment_trustpay_cp_pending_status_id');
        }

        $data['entry_announced_status'] = $this->language->get('entry_announced_status');
        $data['help_announced_status'] = $this->language->get('help_announced_status');

        if (isset($this->request->post['payment_trustpay_cp_announced_status_id'])) {
            $data['payment_trustpay_cp_announced_status_id'] = $this->request->post['payment_trustpay_cp_announced_status_id'];
        } else {
            $data['payment_trustpay_cp_announced_status_id'] = $this->config->get('payment_trustpay_cp_announced_status_id');
        }

        $data['entry_authorized_status'] = $this->language->get('entry_authorized_status');
        $data['help_authorized_status'] = $this->language->get('help_authorized_status');

        if (isset($this->request->post['payment_trustpay_cp_authorized_status_id'])) {
            $data['payment_trustpay_cp_authorized_status_id'] = $this->request->post['payment_trustpay_cp_authorized_status_id'];
        } else {
            $data['payment_trustpay_cp_authorized_status_id'] = $this->config->get('payment_trustpay_cp_authorized_status_id');
        }

        $data['entry_processing_status'] = $this->language->get('entry_processing_status');
        $data['help_processing_status'] = $this->language->get('help_processing_status');

        if (isset($this->request->post['payment_trustpay_cp_processing_status_id'])) {
            $data['payment_trustpay_cp_processing_status_id'] = $this->request->post['payment_trustpay_cp_processing_status_id'];
        } else {
            $data['payment_trustpay_cp_processing_status_id'] = $this->config->get('payment_trustpay_cp_processing_status_id');
        }

        $data['entry_failed_status'] = $this->language->get('entry_failed_status');
        $data['help_failed_status'] = $this->language->get('help_failed_status');

        if (isset($this->request->post['payment_trustpay_cp_failed_status_id'])) {
            $data['payment_trustpay_cp_failed_status_id'] = $this->request->post['payment_trustpay_cp_failed_status_id'];
        } else {
            $data['payment_trustpay_cp_failed_status_id'] = $this->config->get('payment_trustpay_cp_failed_status_id');
        }

        $data['entry_amount_mismatch_status'] = $this->language->get('entry_amount_mismatch_status');
        $data['help_amount_mismatch_status'] = $this->language->get('help_amount_mismatch_status');

        if (isset($this->request->post['payment_trustpay_cp_amount_mismatch_status_id'])) {
            $data['payment_trustpay_cp_amount_mismatch_status_id'] = $this->request->post['payment_trustpay_cp_amount_mismatch_status_id'];
        } else {
            $data['payment_trustpay_cp_amount_mismatch_status_id'] = $this->config->get('payment_trustpay_cp_amount_mismatch_status_id');
        }

        $data['text_status_note'] = $this->language->get('text_status_note');
        $data['text_test_live_note'] = $this->language->get('text_test_live_note');

        $data['entry_notify'] = $this->language->get('entry_notify');

        if (isset($this->request->post['payment_trustpay_cp_notify'])) {
            $data['payment_trustpay_cp_notify'] = $this->request->post['payment_trustpay_cp_notify'];
        } else {
            $data['payment_trustpay_cp_notify'] = $this->config->get('payment_trustpay_cp_notify');
        }

        // Return URLs
        $data['text_return_urls'] = sprintf($this->language->get('text_return_urls'), $this->trustpay_config['api_merchant_portal']['live']);
        
        $url = HTTP_CATALOG . 'index.php?route=';
        
        $data['text_success_return'] = $this->language->get('text_success_return');
        $data['success_return'] = $url . $this->trustpay_config['routes']['success'];
        $data['text_error_return'] = $this->language->get('text_error_return');
        $data['error_return'] = $url . $this->trustpay_config['routes']['error'];
        $data['text_cancel_return'] = $this->language->get('text_cancel_return');
        $data['cancel_return'] = $url . $this->trustpay_config['routes']['cancel'];
        $data['text_notification_url'] = $this->language->get('text_notification_url');
        $data['notification_url'] = $url . $this->trustpay_config['routes']['notification'];

        // About
        $data['text_title'] = $this->language->get('text_title');
        $data['text_version'] = $this->language->get('text_version');
        $data['info_version'] = $this->trustpay_config['version'];
        /*
        if (!in_array(VERSION, $this->trustpay_config['compatibility'])) {
            $data['info_version'] .= $this->language->get('info_version');
        }*/
        $data['text_compatibility'] = $this->language->get('text_compatibility');
        $data['info_compatibility'] = sprintf($this->language->get('info_compatibility'), implode(",", $this->trustpay_config['compatibility']));
        $data['text_documentation'] = $this->language->get('text_documentation');
        $data['info_documentation'] = $this->language->get('info_documentation');
        $data['text_author'] = $this->language->get('text_author');
        $data['info_author'] = $this->language->get('info_author');
        $data['text_license'] = $this->language->get('text_license');
        $data['info_license'] = sprintf($this->language->get('info_license'), date("Y"));

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/trustpay4/payment/trustpay_cp', $data));
    }
    /*
    private function validate() {
        if (!$this->user->hasPermission('modify', 'extension/payment/trustpay_cp')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['payment_trustpay_cp_aid']) {
            $this->error['aid'] = $this->language->get('error_aid');
        }

        if (!$this->request->post['payment_trustpay_cp_key']) {
            $this->error['key'] = $this->language->get('error_key');
        }

        return !$this->error;
    }
    */
    public function save(): void {
        
        $this->load->language('extension/trustpay4/payment/trustpay_cp');
        
        $this->load->model('setting/setting');
        
        $this->request->post['payment_trustpay_cp_config'] = serialize($this->trustpay_config);
        
        $json = [];
        
        if (!$this->user->hasPermission('modify', 'extension/trustpay4/payment/trustpay_cp')) {
            $json['error']['warning'] = $this->language->get('error_permission');
        }
        //var_dump($this->request->post); die;
        if (!$this->request->post['payment_trustpay_cp_aid']) {
            $json['error']['aid'] = $this->language->get('error_aid');
        }

        if (!$this->request->post['payment_trustpay_cp_key']) {
            $json['error']['key'] = $this->language->get('error_key');
        }

        $this->model_setting_setting->editSetting('payment_trustpay_cp', $this->request->post);

        $this->session->data['success'] = $this->language->get('text_success');
        
        $this->response->addHeader('Content-Type: application/json');
	$this->response->setOutput(json_encode($json));

        //$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
    }
}
