
define(
    [
        'jquery',
        'Magento_Checkout/js/view/payment/default',
        'ko',
        'uiRegistry',
        'Magento_Checkout/js/action/set-payment-information',
        'Magento_Checkout/js/model/quote',
        'Magento_Ui/js/model/messages',
        'Magento_Checkout/js/model/full-screen-loader',
    ],
    function ($, Component, ko, registry, setPaymentInformation, quote, Messages, fullScreenLoader) {
        'use strict';
        const TrustPayPopup = {
            init: function () {
                this.iFrame = document.getElementById("TrustPayFrame");
                this.iFrame.style.position = 'fixed';
                this.iFrame.style.left = 0;
                this.iFrame.style.right = 0;
                this.iFrame.style.top = 0;
                this.iFrame.style.bottom = 0;
                this.iFrame.style.width = 0;
                this.iFrame.style.height = 0;
                this.iFrame.style.border = 'none';
                this.iFrame.style.opacity = 0;
                this.iFrame.style.transition = 'opacity .5s ease-in-out';
                this.iFrame.style.zIndex = '99999';
                if (window.addEventListener) {
                    window.addEventListener("message", this.onMessage.bind(this), false);
                } else if (window.attachEvent) {
                    window.attachEvent("onmessage", this.onMessage.bind(this), false);
                }
            },
            onMessage: function (event) {
                let data = event.data;
                if (_.isFunction(this[data.func])) {
                    this[data.func].bind(this).call(null, data.message);
                }
            },
            openPopup: function (src) {
                const self = this,
                    show = function () {
                        self.iFrame.style.height = '100%';
                        self.iFrame.style.width = '100%';
                        self.iFrame.style.opacity = '1';
                        self.iFrame.focus();
                        self.iFrame.contentWindow.postMessage('redirectMessage', '*');
                        self.iFrame.contentWindow.postMessage('authorizationMessage', '*');
                    }
                if (self.iFrame.src !== src) {
                    fullScreenLoader.startLoader()
                    self.iFrame.src = src;
                    self.iFrame.onload = function () {
                        show();
                        fullScreenLoader.stopLoader()
                    };
                } else {
                    show();
                }
            },
            closePopup: function () {
                this.iFrame.style.opacity = 0;
                setTimeout(function () {
                    this.iFrame.style.width = 0;
                    this.iFrame.style.height = 0;
                }.bind(this), 1000);
            },
            redirectPopup: function (url) {
                window.top.location.href = url;
            }
        };
        return Component.extend({
            defaults: {
                template: 'TrustPay_PaymentGateway/payment/trustpay'
            },

            selectedTrustPayMethodGateway: ko.observable(null),
            gateways: ko.observableArray([]),

            initialize: function () {
                this._super();
                this.gateways(this.getTrustPaymentConfig().gateways);
                this.messageContainer = new Messages();
            },
            afterRender: function () {
                TrustPayPopup.init();
            },
            selectedTrustPayMethodGatewayAction: function (gateway) {
                this.selectedTrustPayMethodGateway(gateway);
                return true;
            },

            getTrustPaymentConfig: function () {
                return window.checkoutConfig.trust_payment_config;
            },

            openIFrameAction: function () {
                let data = {method: this.getCode()};
                this.getSetPaymentInformationDeferredObject(data)
                    .done(
                        function () {
                            var ref = this;
                            $.getJSON( this.selectedTrustPayMethodGateway().iframeUrl, function(data) {
                                if(typeof(data.url) != "undefined") {
                                    console.log( "success" );
                                    if(ref.selectedTrustPayMethodGateway().isRedirect) {
                                        console.log( "redirect" );
                                        TrustPayPopup.redirectPopup(data.url);
                                    } else {
                                        console.log( "popup" );
                                        TrustPayPopup.openPopup(data.url);
                                    }
                                }
                            });
                        }.bind(this)
                    );
            },

            defaultGatewayCheck: function (gateway) {
                if (gateway.isDefaultChecked) {
                    this.selectedTrustPayMethodGatewayAction(gateway);
                    return true
                }
                return false;
            },

            getSetPaymentInformationDeferredObject: function (payload) {
                return $.when(
                    setPaymentInformation(this.messageContainer, payload)
                );
            }
        });
    }
);
