<?php

namespace TrustPay\PaymentGateway\ViewModel\Order\Create\Success;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Checkout\Model\Session;
use TrustPay\PaymentGateway\Model\PaymentMethod;

/**
 * Class Script
 * @package TrustPay\PaymentGateway\ViewModel\Order\Create\Success
 */
class Script implements ArgumentInterface
{
    /**
     * @var Session
     */
    private $checkoutSession;

    /**
     * Script constructor.
     * @param Session $checkoutSession
     */
    public function __construct(Session $checkoutSession)
    {
        $this->checkoutSession = $checkoutSession;
    }

    /**
     * @return bool
     */
    public function isRenderScript()
    {
        return $this->checkoutSession->getLastRealOrder()->getPayment()->getMethod() === PaymentMethod::PAYMENT_METHOD_CODE;
    }
}
