<?php

namespace TrustPay\PaymentGateway\Service;

/**
 * Class PaymentProcessingData
 * @package TrustPay\PaymentGateway\Service
 */
class PaymentProcessingData
{
    /**
     * @var
     */
    private $reference;

    /**
     * @var
     */
    private $paymentRequestId;

    /**
     * @var
     */
    private $resultCode;

    /**
     * @param array $requestData
     * @return PaymentProcessingData
     */
    public function setRequestData(array $requestData)
    {
        $this->reference = isset($requestData['Reference']) ? $requestData['Reference'] : null;
        $this->paymentRequestId = isset($requestData['PaymentRequestId']) ? $requestData['PaymentRequestId'] : null;
        $this->resultCode = isset($requestData['ResultCode']) ? $requestData['ResultCode'] : null;
        return $this;
    }

    /**
     * @return bool
     */
    public function isAuthorize()
    {
        return $this->reference && $this->paymentRequestId && isset($this->resultCode);
    }

    /**
     * @return mixed
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * @return mixed
     */
    public function getPaymentRequestId()
    {
        return $this->paymentRequestId;
    }
}
