<?php


namespace TrustPay\PaymentGateway\Plugin\Directory\Block\Adminhtml\Frontend\Currency;

use Magento\Directory\Block\Adminhtml\Frontend\Currency\Base as Subject;
use TrustPay\PaymentGateway\Helper\Data;

/**
 * Class Base
 * @package TrustPay\PaymentGateway\Plugin\Directory\Block\Adminhtml\Frontend\Currency
 */
class Base
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * Base constructor.
     * @param Data $helper
     */
    public function __construct(Data $helper)
    {
        $this->helper = $helper;
    }

    /**
     * @param Subject $subject
     * @param string $result
     * @return string
     */
    public function afterRender(Subject $subject, string $result)
    {
        $result .= '
                <script type="text/javascript">
                    require([
                     \'Magento_Ui/js/modal/alert\',
                     \'jquery\',
                     \'underscore\',
                    ], function(alert, $, _) {
                        $(\'#row_currency_options_base\').change(function(){
                             let selected = $(\'#row_currency_options_base option:selected\').val(),
                             allowedCurrencies = ' . \Laminas\Json\Json::encode($this->helper->getAllowedCurrencies()) . ';
                             if(!_.contains(allowedCurrencies, selected)){
                                let content = \'' . str_replace(["\n", "\r"], '', $this->getMessage()) . '\';
                                alert({
                                title: \'' . __('Finby Payment Gateway') . '\',
                                content: content.replace(\'{base_currency_short_name}\', selected),
                                actions: {
                                    always: function(){}
                                }
                             });
                            }
                        });
                     });
                </script>
        ';

        return $result;
    }

    /**
     * @return \Magento\Framework\Phrase
     */
    protected function getMessage()
    {
        return __(
            'The selected base currency: {base_currency_short_name} is not supported by the finby payment gateway.
            For this reason, it would not be shown as the payment option during the checkout.
             you want to use finby payment gateway, please, select %1 (the one corresponding with your finby account currency) as your base currency',
            implode('/', $this->helper->getAllowedCurrencies())
        );
    }
}
