<?php


namespace TrustPay\PaymentGateway\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use TrustPay\PaymentGateway\Model\PaymentMethod;
use TrustPay\PaymentGateway\Service\PaymentProcessingData;

/**
 * Class CheckoutSubmitAllAfter
 * @package TrustPay\PaymentGateway\Observer
 */
class CheckoutSubmitAllAfter implements ObserverInterface
{
    /**
     * @var PaymentProcessingData
     */
    private $paymentProcessingData;

    /**
     * CheckoutSubmitAllAfter constructor.
     * @param PaymentProcessingData $paymentProcessingData
     */
    public function __construct(PaymentProcessingData $paymentProcessingData)
    {
        $this->paymentProcessingData = $paymentProcessingData;
    }

    /**
     * @inheritDoc
     */
    public function execute(Observer $observer)
    {
        $order = $observer->getOrder();
        if ($order->getPayment()->getMethod() === PaymentMethod::PAYMENT_METHOD_CODE) {
            $order->addStatusHistoryComment('Payment Request ID: ' . $this->paymentProcessingData->getPaymentRequestId())
                ->setIsCustomerNotified(false)
                ->setEntityName('order')
                ->save();
        }
    }
}
