<?php

namespace TrustPay\PaymentGateway\Model;

use Magento\Framework\App\ObjectManager;
use Magento\Payment\Model\Method\AbstractMethod;
use TrustPay\PaymentGateway\Helper\Data;
use TrustPay\PaymentGateway\Service\PaymentProcessingData;

/**
 * Pay In Store payment method model
 */
class PaymentMethod extends AbstractMethod
{
    const PAYMENT_METHOD_CODE = 'trustpay';

    /**
     * @var string
     */
    protected $_code = self::PAYMENT_METHOD_CODE;

    /**
     * @return bool
     */
    public function canAuthorize()
    {
        return $this->getPaymentProcessingData()->isAuthorize();
    }

    /**
     * @param string $currencyCode
     * @return bool
     */
    public function canUseForCurrency($currencyCode)
    {
        /** @var Data $helper */
        $helper = ObjectManager::getInstance()->get(Data::class);
        return in_array($currencyCode, $helper->getAllowedCurrencies());
    }

    /**
     * @return mixed|PaymentProcessingData
     */
    private function getPaymentProcessingData()
    {
        return ObjectManager::getInstance()->get(PaymentProcessingData::class);
    }
}
