<?php


namespace TrustPay\PaymentGateway\Model\Config\Backend;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Value;
use Magento\Directory\Model\Currency;

/**
 * Class NoticeCurrency
 * @package TrustPay\PaymentGateway\Model\Config\Backend
 */
class NoticeCurrency extends Value
{
    /**
     * @return string
     */
    public function getValue()
    {
        return (string)$this->_config->getValue(
            Currency::XML_PATH_CURRENCY_BASE,
            $this->getScope() ?: ScopeConfigInterface::SCOPE_TYPE_DEFAULT,
            $this->getScopeCode()
        );
    }
}
