<?php
namespace TrustPay\PaymentGateway\Model\Config\Backend;

class ImplementationType implements \Magento\Framework\Option\ArrayInterface
{
    const IMPLEMENTATION_TYPE_MERCHANT_PORTAL = 'merchant_portal';
    const IMPLEMENTATION_TYPE_INTERNET_BANKING = 'internet_banking';
    /**
     * Engines list
     *
     * @var array
     */
    private $engines;

    /**
     * @param array $engines
     */
    public function __construct() {
        $this->engines = [
            self::IMPLEMENTATION_TYPE_MERCHANT_PORTAL => __('Merchant Portal'),
            self::IMPLEMENTATION_TYPE_INTERNET_BANKING => __('Internet Banking'),
        ];
    }

    /**
     * @inheritdoc
     */
    public function toOptionArray()
    {
        foreach ($this->engines as $key => $label) {
            $options[] = ['value' => $key, 'label' => $label];
        }
        return $options;
    }
}