<?php

namespace TrustPay\PaymentGateway\Model\Callback\Response;

/**
 * Class Resolver
 * @package TrustPay\PaymentGateway\Model\Callback\Response
 */
class Resolver
{
    const UNKNOWN_RESPONSE_MSG = 'Unknown response code';

    /**
     * @var array
     */
    protected $resultCodes;

    /**
     * Resolver constructor.
     * @param array $resultCodes
     */
    public function __construct(array $resultCodes = [])
    {
        $this->resultCodes = $resultCodes;
    }

    /**
     * @param $code
     * @return bool|mixed
     */
    public function getMessage($code)
    {
        return isset($this->resultCodes[$code]) ? __($this->resultCodes[$code]) : __(self::UNKNOWN_RESPONSE_MSG);
    }
}
