<?php

namespace TrustPay\PaymentGateway\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Encryption\EncryptorInterface;
use Magento\Store\Model\ScopeInterface;

/**
 * Class Config
 * @package TrustPay\PaymentGateway\Helper
 */
class Config extends AbstractHelper
{
    const PATH_CONFIG_ACCOUNT_ID = 'payment/trustpay/account_id';
    const PATH_CONFIG_SECRET_KEY = 'payment/trustpay/secret_key';
    const PATH_CONFIG_BANK_TRANSFERS_TITLE = 'payment/trustpay/bank_title';
    const PATH_CONFIG_CARDS_PAYMENTS_TITLE = 'payment/trustpay/cards_title';
    const PATH_CONFIG_IS_SANDBOX = 'payment/trustpay/is_sandbox_mode_enabled';
    const PATH_CONFIG_SANDBOX_ACCOUNT_ID = 'payment/trustpay/sandbox_account_id';
    const PATH_CONFIG_SANDBOX_SECRET_KEY = 'payment/trustpay/sandbox_secret_key';
    const PATH_CONFIG_CHECKOUT_DISCLAIMER = 'payment/trustpay/checkout_disclaimer';

    /**
     * @var EncryptorInterface
     */
    private $encryptor;

    /**
     * Config constructor.
     * @param Context $context
     * @param EncryptorInterface $encryptor
     */
    public function __construct(Context $context, EncryptorInterface $encryptor)
    {
        $this->encryptor = $encryptor;
        parent::__construct($context);
    }

    /**
     * @param string $scopeType
     * @return bool
     */
    public function getIsSandBoxModeEnabled($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->scopeConfig->isSetFlag(self::PATH_CONFIG_IS_SANDBOX, $scopeType);
    }
    
    
    /**
     * @param string $scopeType
     * @return mixed
     */
    public function getLiveAccountId($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->scopeConfig->getValue(self::PATH_CONFIG_ACCOUNT_ID, $scopeType);
    }

    /**
     * @param string $scopeType
     * @return string
     */
    public function getLiveSecretKey($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->encryptor->decrypt($this->scopeConfig->getValue(self::PATH_CONFIG_SECRET_KEY, $scopeType));
    }

    /**
     * @param string $scopeType
     * @return mixed
     */
    public function getSandBoxAccountId($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->scopeConfig->getValue(self::PATH_CONFIG_SANDBOX_ACCOUNT_ID, $scopeType);
    }

    /**
     * @param string $scopeType
     * @return string
     */
    public function getSandBoxSecretKey($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->encryptor->decrypt($this->scopeConfig->getValue(self::PATH_CONFIG_SANDBOX_SECRET_KEY, $scopeType));
    }

    /**
     * @param string $scopeType
     * @return mixed
     */
    public function getBankTransfersTitle($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->scopeConfig->getValue(self::PATH_CONFIG_BANK_TRANSFERS_TITLE, $scopeType);
    }

    /**
     * @param string $scopeType
     * @return mixed
     */
    public function getCardsPaymentsTitle($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->scopeConfig->getValue(self::PATH_CONFIG_CARDS_PAYMENTS_TITLE, $scopeType);
    }

    /**
     * @param string $scopeType
     * @return mixed
     */
    public function getCheckoutDisclaimer($scopeType = ScopeInterface::SCOPE_STORE)
    {
        return $this->scopeConfig->getValue(self::PATH_CONFIG_CHECKOUT_DISCLAIMER, $scopeType);
    }
}
