<?php

namespace TrustPay\PaymentGateway\Controller\Callback;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Checkout\Model\Type\Onepage;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Quote\Model\QuoteFactory;
use Magento\Quote\Model\QuoteManagement;
use TrustPay\PaymentGateway\Logger\Logger;
use TrustPay\PaymentGateway\Service\PaymentProcessingData;

/**
 * Class Success
 * @package TrustPay\PaymentGateway\Controller\Callback
 */
class Success extends Action implements HttpGetActionInterface
{
    /**
     * @var QuoteFactory
     */
    private $quoteFactory;

    /**
     * @var
     */
    protected $quote;

    /**
     * @var CheckoutSession
     */
    protected $checkoutSession;

    /**
     * @var QuoteManagement
     */
    protected $quoteManager;

    /**
     * @var Logger
     */
    protected $logger;

    /**
     * @var Onepage
     */
    protected $onepageModel;

    /**
     * @var PaymentProcessingData
     */
    private $paymentProcessingData;

    /**
     * Success constructor.
     * @param Context $context
     * @param QuoteFactory $quoteFactory
     * @param CheckoutSession $checkoutSession
     * @param QuoteManagement $quoteManagement
     * @param Logger $logger
     * @param Onepage $onepage
     * @param PaymentProcessingData $paymentProcessingData
     */
    public function __construct(
        Context $context,
        QuoteFactory $quoteFactory,
        CheckoutSession $checkoutSession,
        QuoteManagement $quoteManagement,
        Logger $logger,
        Onepage $onepage,
        PaymentProcessingData $paymentProcessingData
    ) {
        $this->checkoutSession = $checkoutSession;
        $this->quoteManager = $quoteManagement;
        $this->logger = $logger;
        $this->onepageModel = $onepage;
        $this->quoteFactory = $quoteFactory;
        $this->paymentProcessingData = $paymentProcessingData;
        return parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Redirect|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $this->paymentProcessingData->setRequestData($this->getRequest()->getParams());
        try {                                                   // prevent multiple mail send on success page reload - $this->getQuote()->getIsActive()
            if ($this->paymentProcessingData->isAuthorize() && $this->getQuote()->getIsActive()) {
                $this->onepageModel->setQuote($this->getQuote());
                $this->onepageModel->saveOrder();
                $resultRedirect->setUrl($this->_url->getUrl('checkout/onepage/success'));
            } else {
                $this->messageManager->addErrorMessage(__('Incorrect response from payment gateway.'));
                $resultRedirect->setUrl($this->_url->getUrl('checkout/cart'));
            }
        } catch (\Exception $e) {
            // Tato metoda neexistuje. Nejaky stary zdedeny rest.
            //$this->logger->addError($this->paymentProcessingData->getPaymentRequestId() . ': ' . $e->getMessage());
            
            $this->messageManager->addErrorMessage(
                __(
                    'Something went wrong please contact to support. Payment Request ID: %s',
                    $this->paymentProcessingData->getPaymentRequestId()
                )
            );
            $resultRedirect->setUrl($this->_url->getUrl('checkout/cart'));
        }

        return $resultRedirect;
    }

    /**
     * @return \Magento\Quote\Model\Quote
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    protected function getQuote()
    {
        if (!$this->quote) {
            $reference = $this->getRequest()->getParam('Reference');
            $checkoutQuote = $this->checkoutSession->getQuote();
            $quoteByReference = $this->quoteFactory->create()->loadByIdWithoutStore($reference);
            if ($checkoutQuote->getId() !== $quoteByReference->getId()) {
                /*
                $this->logger->addNotice(
                    'Callback \'Reference\' not equal to current checkout quote. Order will be created for quoteId: '
                    . $reference
                );*/
                $this->quote = $quoteByReference;
            } else {
                $this->quote = $checkoutQuote;
            }
        }
        return $this->quote;
    }
}
