<?php


namespace TrustPay\PaymentGateway\Controller\Callback;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;
use TrustPay\PaymentGateway\Model\Callback\Response\Resolver as CallbackResolver;

use TrustPay\PaymentGateway\Helper\Data as Helper;


use TrustPay\PaymentGateway\Model\Lib\ResultCodes;

use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\Request\InvalidRequestException;

use Magento\Sales\Model\Order;

use Magento\Quote\Model\QuoteFactory;

/**
 * Class Notification
 * @package TrustPay\PaymentGateway\Controller\Callback
 */
class Notification extends Action implements CsrfAwareActionInterface
{
    protected $order;
    
    protected $quoteFactory;
    
    /**
     * @var
     */
    protected $callbackResolver;
    
    /**
     * @var Helper
     */
    protected $helper;

    /**
     * Index constructor.
     * @param Context $context
     * @param CallbackResolver $callbackResolver
     * @param Helper $helper
     */
    public function __construct(
        Context $context,
        CallbackResolver $callbackResolver,
        Helper $helper,
        Order $order,
        QuoteFactory $quoteFactory
    ) {
        $this->callbackResolver = $callbackResolver;
        $this->helper = $helper;
        $this->order = $order;
        $this->quoteFactory = $quoteFactory;
        
        return parent::__construct($context);
    }
    
    public function createCsrfValidationException(RequestInterface $request): ? InvalidRequestException
    {
        return null;
    }

    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }

    public function execute()
    {
        
        $params = $this->getRequest()->getParams();
        
        if(isset($params['gateway'])) {
            switch($params['gateway']) {
                case Helper::CARD_GATEWAY_CODE:
                    $data = array();

                    if(isset($params['AccountId'])) $data[] = $params['AccountId'];
                    if(isset($params['Amount']))    $data[] = $params['Amount'];
                    if(isset($params['Currency']))  $data[] = $params['Currency'];
                    if(isset($params['Reference'])) $data[] = $params['Reference'];
                    if(isset($params['Type']))      $data[] = $params['Type'];
                    if(isset($params['ResultCode'])) $data[] = $params['ResultCode'];
                    if(isset($params['PaymentRequestId'])) $data[] = $params['PaymentRequestId'];

                    if(isset($params['CardId'])) {
                        $data[] = $params['CardId'];
                    }

                    if(isset($params['CardMask'])) {
                        $data[] = $params['CardMask'];
                    }

                    if(isset($params['CardExpiration'])) {
                        $data[] = $params['CardExpiration'];
                    }

                    if(isset($params['AuthNumber'])) {
                        $data[] = $params['AuthNumber'];
                    }
                break;
            
                case Helper::WIRE_GATEWAY_CODE:
                    $data = array();
                    
                    if(isset($params['AccountId'])) $data[] = $params['AccountId'];
                    if(isset($params['Amount'])) $data[] = $params['Amount'];
                    if(isset($params['Currency'])) $data[] = $params['Currency'];
                    if(isset($params['Type'])) $data[] = $params['Type'];
                    if(isset($params['ResultCode'])) $data[] = $params['ResultCode'];
                    
                    if(isset($params['CounterAccount'])) {
                        $data[] = $params['CounterAccount'];
                    }

                    if(isset($params['CounterAccountName'])) {
                        $data[] = $params['CounterAccountName'];
                    }

                    if(isset($params['OrderId'])) {
                        $data[] = $params['OrderId'];
                    }

                    if(isset($params['PaymentId'])) $data[] = $params['PaymentId'];
                    if(isset($params['Reference'])) $data[] = $params['Reference'];
                    
                break;
            
            }
            
            if(isset($data) && isset($params['Signature']) && $this->helper->getSignature($data) == $params['Signature']) {
                sleep(12); // pozdrz 12 sekund, kym sa vytvori objednavka v success page
                $this->changeStatus(
                    $params['Reference'],
                    $params['ResultCode'],
                    $params['gateway'] == Helper::CARD_GATEWAY_CODE ? $params['PaymentRequestId'] : $params['PaymentId'],
                    
                );
            }
            else {
                echo 'NO DATA';
            }
        }
    }
    
    protected function changeStatus($quoteId, $resultCode, $transactionId) {
        
        $quoteFactory = $this->quoteFactory->create();
        $quote = $quoteFactory->load($quoteId);
        $orderId = $quote->getReservedOrderId();
        
        $order = $this->order->load($orderId);
        
        switch ($resultCode) {
            case ResultCodes::SUCCESS:
            case ResultCodes::AUTHORIZED:
            case ResultCodes::PROCESSING:
                $order->setStatus("payment_review");
                $order->save();
                echo 'OKAY';
                break;
        }
    }
}
