<?php


namespace TrustPay\PaymentGateway\Controller\Callback;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use TrustPay\PaymentGateway\Model\Callback\Response\Resolver as CallbackResolver;

/**
 * Class Index
 * @package TrustPay\PaymentGateway\Controller\Callback
 */
class Index extends Action implements HttpGetActionInterface
{
    /**
     * @var
     */
    protected $callbackResolver;

    /**
     * Index constructor.
     * @param Context $context
     * @param CallbackResolver $callbackResolver
     */
    public function __construct(
        Context $context,
        CallbackResolver $callbackResolver
    ) {
        $this->callbackResolver = $callbackResolver;
        return parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Redirect|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $this->messageManager->addErrorMessage(
            $this->callbackResolver->getMessage(
                $this->getRequest()->getParam('AcquirerResponseId')
                    ? $this->getRequest()->getParam('AcquirerResponseId')
                    : $this->getRequest()->getParam('ResultCode')
            )
        );
        return $this->resultRedirectFactory->create()->setUrl($this->_url->getUrl('checkout/cart'));
    }
}
