<?php


namespace TrustPay\PaymentGateway\Controller\Callback;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use TrustPay\PaymentGateway\Model\Callback\Response\Resolver as CallbackResolver;
use TrustPay\PaymentGateway\Model\TrustPayConfigProvider;
use Magento\Framework\Controller\Result\JsonFactory;

/**
 * Class Apiurl
 * @package TrustPay\PaymentGateway\Controller\Callback
 */
class Apiurl extends Action implements HttpGetActionInterface
{
    /**
     * @var
     */
    protected $callbackResolver;
    
    /**
     * @var
     */
    protected $trustPayConfigProvider;
    
    protected $resultJsonFactory;

    /**
     * Index constructor.
     * @param Context $context
     * @param CallbackResolver $callbackResolver
     */
    public function __construct(
        Context $context,
        CallbackResolver $callbackResolver,
        TrustPayConfigProvider $trustPayConfigProvider,
        JsonFactory $resultJsonFactory
    ) {
        $this->callbackResolver = $callbackResolver;
        $this->trustPayConfigProvider = $trustPayConfigProvider;
        $this->resultJsonFactory = $resultJsonFactory;
        return parent::__construct($context);
    }

    public function execute()
    {
        $resultJson = $this->resultJsonFactory->create();
        $url = $this->trustPayConfigProvider->getIFrameUrl($this->getRequest()->getParam('gateway'));
        if($url) {
            return $resultJson->setData(['url' => $url]);
        }
    }
}
