<?php

namespace TrustPay\PaymentGateway\Block\Adminhtml\System\Config\Form\Field;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

/**
 * Class Notice
 * @package TrustPay\PaymentGateway\Block\Adminhtml\System\Config\Form\Field
 */
class Notice extends Field
{
    /**
     * @param AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element)
    {
        return '<div class="message message-notice notice">' . $this->getMsg() . '</div>';
    }

    /**
     * @return \Magento\Framework\Phrase
     */
    protected function getMsg()
    {
        return __('This module works only with EUR,CZK currencies for the Bank Transfer.');
    }

}
