<?php

/**
 * Class ModelExtensionPaymentTrustPayCP
 *
 * The OpenCart extension for TrustPay payment gateway API v2.
 * Card payments.
 * Catalog model.
 * https://doc.finby.com/v02
 *
 * @copyright  2020 finby
 * @author     finby
 * @link       https://www.finby.com
 */
class ModelExtensionPaymentTrustPayCP extends Model {
    private $card_accepted_currencies = [
        'AUD',
        'CAD',
        'CZK',
        'DKK',
        'EUR',
        'GBP',
        'HRK',
        'HUF',
        'JPY',
        'NOK',
        'PLN',
        'RON',
        'SEK',
        'USD',
    ];
    
	public function getMethod($address, $total) {
		$this->load->language('extension/payment/trustpay_cp');

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('payment_trustpay_cp_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

		if ($this->config->get('payment_trustpay_cp_total') > $total) {
			$status = false;
		} elseif (!$this->config->get('payment_trustpay_cp_geo_zone_id')) {
			$status = true;
		} elseif ($query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		if (!in_array(mb_strtoupper($this->session->data['currency']), $this->card_accepted_currencies)) {
                    $status = false;
                }
                
		$method_data = array();

		if ($status) {
			$method_data = array(
				'code'       => 'trustpay_cp',
				'title'      => $this->language->get('text_title'),
				'terms'      => '',
				'sort_order' => $this->config->get('payment_trustpay_cp_sort_order')
			);
		}

		return $method_data;
	}
}
